---
-- %%Ignore-License
---

-- remove inconsistent practiced species stades from seasonal interventions.
DELETE FROM practicedspeciesstade WHERE topiaid IN (
  -- Practiced stades, seasonal species
  SELECT DISTINCT pss.topiaid FROM practicedspeciesstade pss,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  practicedintervention pi,
  practicedcropcycleconnection pccc,
  practicedcropcyclenode pccn
  WHERE  pss.speciescode = cps1.code
  AND cps1.croppingplanentry = cpe1.topiaid
  AND pss.practicedintervention = pi.topiaid
  AND pi.practicedcropcycleconnection = pccc.topiaId
  AND pccc.target = pccn.topiaid
  AND cpe1.code != pccn.croppingplanentrycode
  AND pss.topiaid NOT IN (
      SELECT DISTINCT pss.topiaid FROM practicedspeciesstade pss,
      croppingplanspecies cps1,
      croppingplanentry cpe1,
      practicedintervention pi,
      practicedcropcycleconnection pccc,
      practicedcropcyclenode pccn
      WHERE pss.speciescode = cps1.code
      AND cps1.croppingplanentry = cpe1.topiaid
      AND pss.practicedintervention = pi.topiaid
      AND pi.practicedcropcycleconnection = pccc.topiaId
      AND (pccc.target = pccn.topiaid OR pccc.source = pccn.topiaid)
      -- le code de l'action est différent du code du noeud suivant la connexion
      AND cpe1.code != pccn.croppingplanentrycode
      -- le code de l'action est égale au code de l'espèce intermédaire sur la connexion
      AND cpe1.code = pccc.intermediatecroppingplanentrycode
  )
);

-- remove inconsistent practiced species stades from perennial interventions.
DELETE FROM practicedspeciesstade WHERE topiaid IN (
-- Practiced stades, perennial species
  SELECT DISTINCT pss.topiaid FROM
  practicedspeciesstade pss,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  practicedintervention pi,
  practicedcropcyclephase pccp ,
  practicedperennialcropcycle ppcc
  WHERE pss.speciescode = cps1.code
  AND cps1.croppingplanentry = cpe1.topiaid
  AND pss.practicedintervention = pi.topiaid
  AND pi.practicedcropcyclephase = pccp.topiaid
  AND pccp.practicedperennialcropcycle = ppcc.topiaid
  AND ppcc.croppingplanentrycode != cpe1.code
);

-- remove inconsistent seeding action species from seasonal interventions.
DELETE FROM seedingactionspecies WHERE topiaid IN (
-- Practiced seeding, seasonnal species
  SELECT DISTINCT sas.topiaid FROM seedingactionspecies sas ,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  abstractaction aa,
  practicedintervention pi,
  practicedcropcycleconnection pccc,
  practicedcropcyclenode pccn
  WHERE sas.seedingaction = aa.topiaid
  AND sas.speciescode = cps1.code
  AND cps1.croppingplanentry = cpe1.topiaid
  AND aa.practicedintervention = pi.topiaid
  AND pi.practicedcropcycleconnection = pccc.topiaId
  AND pccc.target = pccn.topiaid
  AND cpe1.code != pccn.croppingplanentrycode
  AND sas.topiaid NOT IN (
      SELECT DISTINCT sas.topiaid FROM seedingactionspecies sas ,
      croppingplanspecies cps1,
      croppingplanentry cpe1,
      abstractaction aa,
      practicedintervention pi,
      practicedcropcycleconnection pccc,
      practicedcropcyclenode pccn
      WHERE sas.speciescode = cps1.code
      AND cps1.croppingplanentry = cpe1.topiaid
      AND sas.seedingaction = aa.topiaid
      AND aa.practicedintervention = pi.topiaid
      AND pi.practicedcropcycleconnection = pccc.topiaId
      -- il n'y a que le node après qui nous intéresse
      AND pccc.target = pccn.topiaid

      -- le code de l'action est différent du code du noeud suivant la connexion
      AND cpe1.code != pccn.croppingplanentrycode
      -- le code de l'action est égale au code de l'espèce intermédaire sur la connexion
      AND cpe1.code = pccc.intermediatecroppingplanentrycode
  )
);

-- remove inconsistent seeding action species from perennial interventions.
DELETE FROM seedingactionspecies WHERE topiaid IN (
-- Practiced seedings, perennial species
  SELECT DISTINCT sas.topiaid
  FROM seedingactionspecies sas ,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  abstractaction aa,
  practicedintervention pi,
  practicedcropcyclephase pccp,
  practicedperennialcropcycle ppcc
  WHERE sas.seedingaction = aa.topiaid
  AND sas.speciescode = cps1.code
  AND cps1.croppingplanentry = cpe1.topiaid
  AND aa.practicedintervention = pi.topiaid
  AND pi.practicedcropcyclephase = pccp.topiaid
  AND pccp.practicedperennialcropcycle = ppcc.topiaid
  AND cpe1.code != ppcc.croppingplanentrycode
);